import twilio from "twilio";

function configured() {
  return Boolean(process.env.TWILIO_ACCOUNT_SID && process.env.TWILIO_AUTH_TOKEN);
}

export function twilioConfigured() {
  return configured();
}

function client() {
  if (!configured()) return null;
  return twilio(process.env.TWILIO_ACCOUNT_SID, process.env.TWILIO_AUTH_TOKEN);
}

export async function sendSms({ to, body }) {
  const c = client();
  const from = process.env.TWILIO_SMS_FROM;
  if (!c || !from) return { ok: false, reason: "not_configured" };

  const msg = await c.messages.create({ from, to, body });
  return { ok: true, sid: msg.sid };
}

export async function sendWhatsapp({ to, body }) {
  const c = client();
  const from = process.env.TWILIO_WHATSAPP_FROM;
  if (!c || !from) return { ok: false, reason: "not_configured" };

  const msg = await c.messages.create({ from, to: `whatsapp:${to.replace(/^whatsapp:/, "")}`, body });
  return { ok: true, sid: msg.sid };
}
