export function requireAdmin(req) {
  const key = req.headers.get("x-admin-key");
  const expected = process.env.ADMIN_KEY || "";
  return Boolean(key && expected && key === expected);
}

export function adminError() {
  return new Response(JSON.stringify({ error: "Unauthorized" }), {
    status: 401,
    headers: { "content-type": "application/json" },
  });
}
