import Link from "next/link";

export default function Home() {
  return (
    <main className="min-h-screen bg-gradient-to-b from-neutral-950 to-neutral-900 text-white">
      <div className="mx-auto max-w-5xl px-6 py-16">
        <div className="flex items-center justify-between gap-4">
          <div>
            <h1 className="text-3xl font-semibold tracking-tight">Ftesa Digjitale</h1>
            <p className="mt-2 text-neutral-300">
              Krijo ftesa online per dasma me link unik per secilin mysafir.
            </p>
          </div>
          <Link
            href="/admin"
            className="rounded-xl bg-white/10 px-4 py-2 text-sm font-medium hover:bg-white/15"
          >
            Admin
          </Link>
        </div>

        <div className="mt-10 grid gap-6 md:grid-cols-3">
          <Card title="Link unik">
            Cdo mysafir merr nje link privat (token), me emrin e tij ne ftesë.
          </Card>
          <Card title="Hapje + muzike">
            Pamje hapese me animacion (tap-to-open) dhe muzike te lehte.
          </Card>
          <Card title="RSVP">
            Konfirmim pjesemarrje + mesazh, me raportim ne panelin admin.
          </Card>
        </div>

        <div className="mt-12 rounded-2xl border border-white/10 bg-white/5 p-6">
          <div className="text-sm text-neutral-300">Test shpejte</div>
          <div className="mt-2 text-neutral-200">
            Nese ke bere <code className="rounded bg-black/40 px-2 py-1">npm run seed</code>, provo:
          </div>
          <div className="mt-2 flex flex-col gap-2 text-sm">
            <code className="rounded bg-black/40 px-3 py-2">/i/demo-token</code>
            <code className="rounded bg-black/40 px-3 py-2">/admin</code>
          </div>
        </div>

        <footer className="mt-14 text-xs text-neutral-500">
          MVP – gati per zgjerim (multi-event, templates, pages, payment, etj.).
        </footer>
      </div>
    </main>
  );
}

function Card({ title, children }) {
  return (
    <div className="rounded-2xl border border-white/10 bg-white/5 p-5">
      <div className="text-base font-semibold">{title}</div>
      <div className="mt-2 text-sm text-neutral-300">{children}</div>
    </div>
  );
}
