"use client";

import Link from "next/link";
import { useEffect, useState } from "react";

function getKey() {
  try { return localStorage.getItem("ADMIN_KEY") || ""; } catch { return ""; }
}

export default function AdminHome() {
  const [key, setKey] = useState("");
  const [events, setEvents] = useState(null);
  const [error, setError] = useState("");

  useEffect(() => {
    const k = getKey();
    setKey(k);
    if (!k) return;
    load(k);
  }, []);

  async function load(k) {
    setError("");
    const res = await fetch("/api/events", { headers: { "x-admin-key": k } });
    if (!res.ok) { setError("S'ka autorizim. Shko te Login."); setEvents(null); return; }
    const json = await res.json();
    setEvents(json.events || []);
  }

  if (!key) {
    return (
      <main className="min-h-screen grid place-items-center bg-neutral-950 text-white">
        <div className="max-w-md px-6 text-center">
          <div className="text-2xl font-semibold">Admin</div>
          <div className="mt-2 text-sm text-neutral-300">Duhet ADMIN_KEY per me vazhdu.</div>
          <Link className="mt-5 inline-block rounded-xl bg-white px-4 py-2 text-sm font-semibold text-black" href="/admin/login">
            Login
          </Link>
        </div>
      </main>
    );
  }

  return (
    <main className="min-h-screen bg-neutral-950 text-white">
      <div className="mx-auto max-w-5xl px-6 py-10">
        <div className="flex items-start justify-between gap-4">
          <div>
            <div className="text-xs tracking-widest text-neutral-400">PANEL</div>
            <h1 className="mt-2 text-2xl font-semibold">Eventet</h1>
            {error ? <div className="mt-2 text-sm text-red-300">{error}</div> : null}
          </div>
          <div className="flex gap-2">
            <Link href="/admin/events/new" className="rounded-xl bg-white px-4 py-2 text-sm font-semibold text-black hover:bg-neutral-200">
              + Event i ri
            </Link>
            <Link href="/admin/login" className="rounded-xl border border-white/10 px-4 py-2 text-sm text-neutral-200 hover:bg-white/5">
              Ndrysho Key
            </Link>
          </div>
        </div>

        <div className="mt-8 grid gap-4">
          {events === null ? (
            <div className="rounded-2xl border border-white/10 bg-white/5 p-5 text-sm text-neutral-300">
              Duke ngarkuar…
            </div>
          ) : events.length === 0 ? (
            <div className="rounded-2xl border border-white/10 bg-white/5 p-5 text-sm text-neutral-300">
              S'ka event. Krijo nje te ri.
            </div>
          ) : (
            events.map((e) => (
              <Link
                key={e.id}
                href={`/admin/events/${e.id}`}
                className="rounded-2xl border border-white/10 bg-white/5 p-5 hover:bg-white/10"
              >
                <div className="flex flex-wrap items-center justify-between gap-3">
                  <div>
                    <div className="text-base font-semibold">{e.coupleA} & {e.coupleB}</div>
                    <div className="mt-1 text-sm text-neutral-300">{e.venueName}</div>
                  </div>
                  <div className="text-xs text-neutral-400">{new Date(e.dateISO).toLocaleString("sq-AL")}</div>
                </div>
              </Link>
            ))
          )}
        </div>
      </div>
    </main>
  );
}
